/*
 * Decompiled with CFR 0.152.
 */
package com.ffcs.ebp.ebpsdk;

import com.ffcs.ebp.ebpsdk.common.Response;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class YunSign {
    private String url;
    private String body;
    private String ak;
    private String sk;

    public YunSign() {
    }

    public YunSign(String url, String ak, String sk, String body) {
        this.url = url;
        this.body = body;
        this.ak = ak;
        this.sk = sk;
    }

    private String getSign(Date eopDate) {
        String calculateContentHash = this.getSHA256(this.body);
        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd");
        Date nowdate = new Date();
        String singerDate = TIME_FORMATTER.format(nowdate);
        String singerDd = DATE_FORMATTER.format(nowdate);
        try {
            URL url = new URL(this.url);
            String host = url.getHost();
            String CampmocalHeader = String.format("eop-date:%s\nhost:%s\n", singerDate, host);
            String path = url.getPath();
            if (path == null || path.length() < 1) {
                path = "/";
            }
            if (path.charAt(path.length() - 1) != '/') {
                path = path + "/";
            }
            String query = url.getQuery();
            String afterQuery = "";
            if (query != null) {
                Object[] param = query.split("&");
                Arrays.sort(param);
                for (Object str : param) {
                    afterQuery = afterQuery.length() < 1 ? afterQuery + (String)str : afterQuery + "&" + (String)str;
                }
            }
            String sigture = path + "\n" + CampmocalHeader + "\n" + afterQuery + "\n" + calculateContentHash;
            String kSecret = this.sk;
            byte[] kheader = this.HmacSHA256(singerDate.getBytes(), kSecret.getBytes());
            byte[] kargs = this.HmacSHA256(this.ak.getBytes(), kheader);
            byte[] kbody = this.HmacSHA256(singerDd.getBytes(), kargs);
            String Signature2 = Base64.getEncoder().encodeToString(this.HmacSHA256(sigture.getBytes("UTF-8"), kbody));
            String signHeader = String.format("%s Headers=eop-date;host Signature=%s", this.ak, Signature2);
            return signHeader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doGet() {
        CloseableHttpClient httpClient = null;
        Closeable response = null;
        Response result = new Response();
        try {
            httpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(this.url);
            SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eopDate = new Date();
            httpGet.setHeader("Eop-Authorization", this.getSign(eopDate));
            httpGet.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
            System.out.println("\u8bf7\u6c42\u5934\u90e8:");
            for (Header header : httpGet.getAllHeaders()) {
                System.out.println(header.getName() + ":" + header.getValue());
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute(httpGet);
            HttpEntity entity = response.getEntity();
            result.setBody(EntityUtils.toString(entity));
            result.setStatusCode(response.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doPost() {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        Response result = new Response();
        httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(this.url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        Date eopDate = new Date();
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setHeader("Eop-Authorization", this.getSign(eopDate));
        httpPost.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
        System.out.println("\u8bf7\u6c42\u5934\u90e8:");
        for (Header header : httpPost.getAllHeaders()) {
            System.out.println(header.getName() + ":" + header.getValue());
        }
        try {
            StringEntity data = new StringEntity(this.body, Charset.forName("UTF-8"));
            httpPost.setEntity(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            httpResponse = httpClient.execute(httpPost);
            HttpEntity entity = httpResponse.getEntity();
            result.setBody(EntityUtils.toString(entity));
            result.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpResponse) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doPut() {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        Response result = new Response();
        httpClient = HttpClients.createDefault();
        HttpPut httpPut = new HttpPut(this.url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
        httpPut.setConfig(requestConfig);
        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        Date eopDate = new Date();
        httpPut.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPut.setHeader("Eop-Authorization", this.getSign(eopDate));
        httpPut.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
        System.out.println("\u8bf7\u6c42\u5934\u90e8:");
        for (Header header : httpPut.getAllHeaders()) {
            System.out.println(header.getName() + ":" + header.getValue());
        }
        try {
            StringEntity data = new StringEntity(this.body, Charset.forName("UTF-8"));
            httpPut.setEntity(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            httpResponse = httpClient.execute(httpPut);
            HttpEntity entity = httpResponse.getEntity();
            result.setBody(EntityUtils.toString(entity));
            result.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpResponse) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doDelete() {
        CloseableHttpClient httpClient = null;
        Closeable response = null;
        Response result = new Response();
        try {
            httpClient = HttpClients.createDefault();
            HttpDelete httpDelete = new HttpDelete(this.url);
            SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eopDate = new Date();
            httpDelete.setHeader("Eop-Authorization", this.getSign(eopDate));
            httpDelete.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
            System.out.println("\u8bf7\u6c42\u5934\u90e8:");
            for (Header header : httpDelete.getAllHeaders()) {
                System.out.println(header.getName() + ":" + header.getValue());
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
            httpDelete.setConfig(requestConfig);
            response = httpClient.execute(httpDelete);
            HttpEntity entity = response.getEntity();
            result.setBody(EntityUtils.toString(entity));
            result.setStatusCode(response.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        byte[] var2 = data;
        int var3 = data.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            byte b = var2[var4];
            String hex = Integer.toHexString(b);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    private String getSHA256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return this.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException var3) {
            return null;
        }
    }

    private byte[] HmacSHA256(byte[] data, byte[] key) throws Exception {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException var5) {
            return null;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}

