/*
 * Decompiled with CFR 0.152.
 */
package com.ffcs.ebp.ebpsdk.security;

import com.ffcs.ebp.ebpsdk.security.Base64;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class AuthBase64 {
    protected static char getChar(int sixbit) {
        if (sixbit >= 0 && sixbit <= 25) {
            return (char)(65 + sixbit);
        }
        if (sixbit >= 26 && sixbit <= 51) {
            return (char)(97 + (sixbit - 26));
        }
        if (sixbit >= 52 && sixbit <= 61) {
            return (char)(48 + (sixbit - 52));
        }
        if (sixbit == 62) {
            return '+';
        }
        return sixbit != 63 ? (char)'?' : '/';
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        return c != '=' ? -1 : 0;
    }

    public static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < raw.length; i += 3) {
            encoded.append(AuthBase64.encodeBlock(raw, i));
        }
        return encoded.toString();
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int sixbit;
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack < 2 ? slack : 2;
        for (int i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            sixbit = b >= 0 ? b : b + 256;
            block += sixbit << 8 * (2 - i);
        }
        char[] base64 = new char[4];
        for (int i = 0; i < 4; ++i) {
            sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = AuthBase64.getChar(sixbit);
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    public static byte[] decode(String base64) {
        int pad = 0;
        int length = base64.length() - 1;
        while (base64.charAt(length) == '=') {
            ++pad;
            --length;
        }
        length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawindex = 0;
        for (int i = 0; i < base64.length(); i += 4) {
            int block = (AuthBase64.getValue(base64.charAt(i)) << 18) + (AuthBase64.getValue(base64.charAt(i + 1)) << 12) + (AuthBase64.getValue(base64.charAt(i + 2)) << 6) + AuthBase64.getValue(base64.charAt(i + 3));
            for (int j = 0; j < 3 && rawindex + j < raw.length; ++j) {
                raw[rawindex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
            }
            rawindex += 3;
        }
        return raw;
    }

    public static String objectToString(Object o) {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32000);
        try {
            ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(baos));
            os.flush();
            os.writeObject(o);
            os.flush();
        }
        catch (IOException var3) {
            var3.printStackTrace();
        }
        return AuthBase64.encode(baos.toByteArray());
    }

    public static Object stringToObject(String s) {
        if (s == null) {
            return null;
        }
        byte[] byteArray = AuthBase64.decode(s);
        ByteArrayInputStream baos = new ByteArrayInputStream(byteArray);
        try {
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(baos));
            return is.readObject();
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String key = "MTIzNA==";
        System.err.println(new String(Base64.decode(key)));
    }
}

