/*
 * Decompiled with CFR 0.152.
 */
package com.ffcs.ebp.ebpsdk.security;

public final class QuickLZ {
    public static final int QLZ_STREAMING_BUFFER = 0;
    public static final int QLZ_MEMORY_SAFE = 0;
    public static final int QLZ_VERSION_MAJOR = 1;
    public static final int QLZ_VERSION_MINOR = 5;
    public static final int QLZ_VERSION_REVISION = 0;
    private static final int HASH_VALUES = 4096;
    private static final int MINOFFSET = 2;
    private static final int UNCONDITIONAL_MATCHLEN = 6;
    private static final int UNCOMPRESSED_END = 4;
    private static final int CWORD_LEN = 4;
    private static final int DEFAULT_HEADERLEN = 9;
    private static final int QLZ_POINTERS_1 = 1;
    private static final int QLZ_POINTERS_3 = 16;

    static int headerLen(byte[] source) {
        return (source[0] & 2) == 2 ? 9 : 3;
    }

    public static long sizeDecompressed(byte[] source) {
        return QuickLZ.headerLen(source) == 9 ? QuickLZ.fast_read(source, 5, 4) : QuickLZ.fast_read(source, 2, 1);
    }

    public static long sizeCompressed(byte[] source) {
        return QuickLZ.headerLen(source) == 9 ? QuickLZ.fast_read(source, 1, 4) : QuickLZ.fast_read(source, 1, 1);
    }

    private static void write_header(byte[] dst, int level, boolean compressible, int size_compressed, int size_decompressed) {
        dst[0] = (byte)(2 | (compressible ? 1 : 0));
        dst[0] = (byte)(dst[0] | (byte)(level << 2));
        dst[0] = (byte)(dst[0] | 0x40);
        dst[0] = (byte)(dst[0] | 0);
        QuickLZ.fast_write(dst, 1, size_decompressed, 4);
        QuickLZ.fast_write(dst, 5, size_compressed, 4);
    }

    public static byte[] compress(byte[] source, int level) {
        int src = 0;
        int dst = 13;
        long cword_val = 0x80000000L;
        int cword_ptr = 9;
        byte[] destination = new byte[source.length + 400];
        int[] cachetable = new int[4096];
        byte[] hash_counter = new byte[4096];
        int fetch = 0;
        int last_matchstart = source.length - 6 - 4 - 1;
        int lits = 0;
        if (level != 1 && level != 3) {
            throw new RuntimeException("Java version only supports level 1 and 3");
        }
        int[][] hashtable = level == 1 ? new int[4096][1] : new int[4096][16];
        if (source.length == 0) {
            return new byte[0];
        }
        if (src <= last_matchstart) {
            fetch = (int)QuickLZ.fast_read(source, src, 3);
        }
        while (src <= last_matchstart) {
            int m;
            int old_src;
            int matchlen;
            int offset2;
            int o;
            if ((cword_val & 1L) == 1L) {
                if (src > 3 * (source.length >> 2) && dst > src - (src >> 5)) {
                    byte[] d2 = new byte[source.length + 9];
                    QuickLZ.write_header(d2, level, false, source.length, source.length + 9);
                    System.arraycopy(source, 0, d2, 9, source.length);
                    return d2;
                }
                QuickLZ.fast_write(destination, cword_ptr, cword_val >>> 1 | 0x80000000L, 4);
                cword_ptr = dst;
                dst += 4;
                cword_val = 0x80000000L;
            }
            if (level == 1) {
                o = (fetch >>> 12 ^ fetch) & 0xFFF;
                offset2 = hashtable[o][0];
                matchlen = cachetable[o] ^ fetch;
                cachetable[o] = fetch;
                hashtable[o][0] = src;
                if (matchlen != 0 || hash_counter[o] == 0 || src - offset2 <= 2 && (src != offset2 + 1 || lits < 3 || src <= 3 || source[src] != source[src - 3] || source[src] != source[src - 2] || source[src] != source[src - 1] || source[src] != source[src + 1] || source[src] != source[src + 2])) {
                    ++lits;
                    hash_counter[o] = 1;
                    destination[dst] = source[src];
                    cword_val >>>= 1;
                    ++dst;
                    fetch = fetch >>> 8 & 0xFFFF | (source[++src + 2] & 0xFF) << 16;
                    continue;
                }
                cword_val = cword_val >>> 1 | 0x80000000L;
                if (source[offset2 + 3] != source[src + 3]) {
                    old_src = 1 | o << 4;
                    destination[dst + 0] = (byte)(old_src >>> 0);
                    destination[dst + 1] = (byte)(old_src >>> 8);
                    src += 3;
                    dst += 2;
                } else {
                    int f;
                    old_src = src;
                    int n = m = source.length - 4 - src + 1 - 1 > 255 ? 255 : source.length - 4 - src + 1 - 1;
                    if (source[offset2 + (src += 4) - old_src] == source[src] && source[offset2 + ++src - old_src] == source[src]) {
                        ++src;
                        while (source[offset2 + (src - old_src)] == source[src] && src - old_src < m) {
                            ++src;
                        }
                    }
                    matchlen = src - old_src;
                    o <<= 4;
                    if (matchlen < 18) {
                        f = o | matchlen - 2;
                        destination[dst + 0] = (byte)(f >>> 0);
                        destination[dst + 1] = (byte)(f >>> 8);
                        dst += 2;
                    } else {
                        f = o | matchlen << 16;
                        QuickLZ.fast_write(destination, dst, f, 3);
                        dst += 3;
                    }
                }
                lits = 0;
                fetch = (int)QuickLZ.fast_read(source, src, 3);
                continue;
            }
            fetch = (int)QuickLZ.fast_read(source, src, 3);
            boolean best_k = false;
            int remaining = source.length - 4 - src + 1 - 1 > 255 ? 255 : source.length - 4 - src + 1 - 1;
            int hash = (fetch >>> 12 ^ fetch) & 0xFFF;
            int c = hash_counter[hash];
            matchlen = 0;
            offset2 = 0;
            for (old_src = 0; old_src < 16 && (c > old_src || c < 0); ++old_src) {
                o = hashtable[hash][old_src];
                if ((byte)fetch != source[o] || (byte)(fetch >>> 8) != source[o + 1] || (byte)(fetch >>> 16) != source[o + 2] || o >= src - 2) continue;
                for (m = 3; source[o + m] == source[src + m] && m < remaining; ++m) {
                }
                if (m <= matchlen && (m != matchlen || o <= offset2)) continue;
                offset2 = o;
                matchlen = m;
            }
            hashtable[hash][c & 0xF] = src;
            hash_counter[hash] = c = (byte)(c + 1);
            if (matchlen >= 3 && src - offset2 < 131071) {
                int offset = src - offset2;
                for (int u = 1; u < matchlen; ++u) {
                    fetch = (int)QuickLZ.fast_read(source, src + u, 3);
                    int n = hash = (fetch >>> 12 ^ fetch) & 0xFFF;
                    hash_counter[n] = (byte)(hash_counter[n] + 1);
                    hashtable[hash][c & 0xF] = src + u;
                }
                src += matchlen;
                cword_val = cword_val >>> 1 | 0x80000000L;
                if (matchlen == 3 && offset <= 63) {
                    QuickLZ.fast_write(destination, dst, offset << 2, 1);
                    ++dst;
                    continue;
                }
                if (matchlen == 3 && offset <= 16383) {
                    QuickLZ.fast_write(destination, dst, offset << 2 | 1, 2);
                    dst += 2;
                    continue;
                }
                if (matchlen <= 18 && offset <= 1023) {
                    QuickLZ.fast_write(destination, dst, matchlen - 3 << 2 | offset << 6 | 2, 2);
                    dst += 2;
                    continue;
                }
                if (matchlen <= 33) {
                    QuickLZ.fast_write(destination, dst, matchlen - 2 << 2 | offset << 7 | 3, 3);
                    dst += 3;
                    continue;
                }
                QuickLZ.fast_write(destination, dst, matchlen - 3 << 7 | offset << 15 | 3, 4);
                dst += 4;
                continue;
            }
            destination[dst] = source[src];
            cword_val >>>= 1;
            ++src;
            ++dst;
        }
        while (src <= source.length - 1) {
            if ((cword_val & 1L) == 1L) {
                QuickLZ.fast_write(destination, cword_ptr, cword_val >>> 1 | 0x80000000L, 4);
                cword_ptr = dst;
                dst += 4;
                cword_val = 0x80000000L;
            }
            destination[dst] = source[src];
            ++src;
            ++dst;
            cword_val >>>= 1;
        }
        while ((cword_val & 1L) != 1L) {
            cword_val >>>= 1;
        }
        QuickLZ.fast_write(destination, cword_ptr, cword_val >>> 1 | 0x80000000L, 4);
        QuickLZ.write_header(destination, level, true, source.length, dst);
        byte[] d2 = new byte[dst];
        System.arraycopy(destination, 0, d2, 0, dst);
        return d2;
    }

    static long fast_read(byte[] a, int i, int numbytes) {
        long l = 0L;
        for (int j = 0; j < numbytes; ++j) {
            l |= ((long)a[i + j] & 0xFFL) << j * 8;
        }
        return l;
    }

    static void fast_write(byte[] a, int i, long value, int numbytes) {
        for (int j = 0; j < numbytes; ++j) {
            a[i + j] = (byte)(value >>> j * 8);
        }
    }

    public static byte[] decompress(byte[] source) throws Exception {
        int size = (int)QuickLZ.sizeDecompressed(source);
        int src = QuickLZ.headerLen(source);
        int dst = 0;
        long cword_val = 1L;
        byte[] destination = new byte[size];
        int[] hashtable = new int[4096];
        byte[] hash_counter = new byte[4096];
        int last_matchstart = size - 6 - 4 - 1;
        int last_hashed = -1;
        int fetch = 0;
        int level = source[0] >>> 2 & 3;
        if (level != 1 && level != 3) {
            throw new RuntimeException("Java version only supports level 1 and 3 , The level " + level);
        }
        if ((source[0] & 1) != 1) {
            byte[] d2 = new byte[size];
            System.arraycopy(source, QuickLZ.headerLen(source), d2, 0, size);
            return d2;
        }
        while (true) {
            int matchlen;
            int hash;
            if (cword_val == 1L) {
                cword_val = QuickLZ.fast_read(source, src, 4);
                src += 4;
                if (dst <= last_matchstart) {
                    fetch = level == 1 ? (int)QuickLZ.fast_read(source, src, 3) : (int)QuickLZ.fast_read(source, src, 4);
                }
            }
            if ((cword_val & 1L) == 1L) {
                int offset;
                int offset2;
                cword_val >>>= 1;
                if (level == 1) {
                    hash = fetch >>> 4 & 0xFFF;
                    offset2 = hashtable[hash];
                    if ((fetch & 0xF) != 0) {
                        matchlen = (fetch & 0xF) + 2;
                        src += 2;
                    } else {
                        matchlen = source[src + 2] & 0xFF;
                        src += 3;
                    }
                } else {
                    if ((fetch & 3) == 0) {
                        offset = (fetch & 0xFF) >>> 2;
                        matchlen = 3;
                        ++src;
                    } else if ((fetch & 2) == 0) {
                        offset = (fetch & 0xFFFF) >>> 2;
                        matchlen = 3;
                        src += 2;
                    } else if ((fetch & 1) == 0) {
                        offset = (fetch & 0xFFFF) >>> 6;
                        matchlen = (fetch >>> 2 & 0xF) + 3;
                        src += 2;
                    } else if ((fetch & 0x7F) != 3) {
                        offset = fetch >>> 7 & 0x1FFFF;
                        matchlen = (fetch >>> 2 & 0x1F) + 2;
                        src += 3;
                    } else {
                        offset = fetch >>> 15;
                        matchlen = (fetch >>> 7 & 0xFF) + 3;
                        src += 4;
                    }
                    offset2 = dst - offset;
                }
                destination[dst + 0] = destination[offset2 + 0];
                destination[dst + 1] = destination[offset2 + 1];
                destination[dst + 2] = destination[offset2 + 2];
                for (offset = 3; offset < matchlen; ++offset) {
                    destination[dst + offset] = destination[offset2 + offset];
                }
                dst += matchlen;
                if (level != 1) {
                    fetch = (int)QuickLZ.fast_read(source, src, 4);
                } else {
                    fetch = (int)QuickLZ.fast_read(destination, last_hashed + 1, 3);
                    while (last_hashed < dst - matchlen) {
                        hash = (fetch >>> 12 ^ fetch) & 0xFFF;
                        hashtable[hash] = ++last_hashed;
                        hash_counter[hash] = 1;
                        fetch = fetch >>> 8 & 0xFFFF | (destination[last_hashed + 3] & 0xFF) << 16;
                    }
                    fetch = (int)QuickLZ.fast_read(source, src, 3);
                }
                last_hashed = dst - 1;
                continue;
            }
            if (dst > last_matchstart) {
                while (dst <= size - 1) {
                    if (cword_val == 1L) {
                        src += 4;
                        cword_val = 0x80000000L;
                    }
                    destination[dst] = source[src];
                    ++dst;
                    ++src;
                    cword_val >>>= 1;
                }
                return destination;
            }
            destination[dst] = source[src];
            ++dst;
            ++src;
            cword_val >>>= 1;
            if (level != 1) {
                fetch = fetch >> 8 & 0xFFFF | (source[src + 2] & 0xFF) << 16 | (source[src + 3] & 0xFF) << 24;
                continue;
            }
            while (last_hashed < dst - 3) {
                matchlen = (int)QuickLZ.fast_read(destination, ++last_hashed, 3);
                hash = (matchlen >>> 12 ^ matchlen) & 0xFFF;
                hashtable[hash] = last_hashed;
                hash_counter[hash] = 1;
            }
            fetch = fetch >> 8 & 0xFFFF | (source[src + 2] & 0xFF) << 16;
        }
    }
}

