/*
 * Decompiled with CFR 0.152.
 */
package com.ffcs.ebp.ebpsdk.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class RSAEncryptUtil {
    private static final String DEFAULT_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDWlAiJ1UbXsI7J6JqrTJPPRp2G\rVRaelL3GaNOiUoibI6is+R1gDr5krUhd/IQnRGesvxw1PdXoMXgWxYWtWY/DsQgw\rsji5VoSROweTepSaCCN2OnXdqooH70CjiD3Fm7U4UBChstQ4bAI1xC1EkaaHgbXq\rkw3bov0lg5VJqzd1BQIDAQAB\r";
    private static final String DEFAULT_PRIVATE_KEY = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANaUCInVRtewjsno\rmqtMk89GnYZVFp6UvcZo06JSiJsjqKz5HWAOvmStSF38hCdEZ6y/HDU91egxeBbF\rha1Zj8OxCDCyOLlWhJE7B5N6lJoII3Y6dd2qigfvQKOIPcWbtThQEKGy1DhsAjXE\rLUSRpoeBteqTDdui/SWDlUmrN3UFAgMBAAECgYBdYdUJbvjCm0K42fKdw9i7puac\r9GDAqMiiFTKs/LAYm/8nL8655BC1rbfFt0Qn9pwL0KvM+9kgkI7LkjBnzYdDfY2J\rykUwZtG+g7Kwehw773shA+Y4NAUy6FJN9WcLkrfrpO0KQVs7BJ52eVUM48ujMXfn\rtPnqamW5qcvxMWbEQQJBAPU4jlZLKUxuzo29yBLXx3vZZHtrUlWq7greewqNjC7l\rxPa4+ktzCQvgTosIKJBGcSaWIMTjC/wOfPBd+1rGydECQQDgAqinIwH81dl2bRO3\rZpmgMnnyUWzyNuKx61n1n6DR5FDv3r9pICSLA8Lx2FrfoWL9oYO7ZKXgLc2RnOdQ\rN1D1AkB4kcEyXqxEn2rBuGFKGnxDwcStBjyqUGvQPkmjC6u0V1b7tEGknUACbdxQ\rccd4AJqbzU75X2VCHmGB0cPHg1wxAkAiQ0XYipo7OdpRKs3hN2g4AIB2d83aHlr+\rK6lO0GOgtvNKPR+5zJjKSoD+zMDZg63IbXPgrbxRVbAjnYQj2NIhAkANi2INnl5O\rxGa4fDNE5FDhPB9Y+cLysxK+A2CtVFY7gZqJO8wFU7Sgbzyg1365Z22387IMg56g\raZJpSTpAXMqc\r";
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void genKeyPair() {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException var3) {
            var3.printStackTrace();
        }
        if (keyPairGen == null) {
            throw new NullPointerException("keyPairGen\u521d\u59cb\u5316\u5f02\u5e38");
        }
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        this.privateKey = (RSAPrivateKey)keyPair.getPrivate();
        this.publicKey = (RSAPublicKey)keyPair.getPublic();
    }

    public void loadPublicKey(InputStream in) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
            this.loadPublicKey(sb.toString());
        }
        catch (IOException var5) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u6d41\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException var6) {
            throw new Exception("\u516c\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    public void loadPublicKey(String publicKeyStr) throws Exception {
        try {
            BASE64Decoder base64Decoder = new BASE64Decoder();
            byte[] buffer = base64Decoder.decodeBuffer(publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            this.publicKey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException var6) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException var7) {
            throw new Exception("\u516c\u94a5\u975e\u6cd5");
        }
        catch (IOException var8) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u5185\u5bb9\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException var9) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public void loadPrivateKey(InputStream in) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
            this.loadPrivateKey(sb.toString());
        }
        catch (IOException var5) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException var6) {
            throw new Exception("\u79c1\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    public void loadPrivateKey(String privateKeyStr) throws Exception {
        try {
            BASE64Decoder base64Decoder = new BASE64Decoder();
            byte[] buffer = base64Decoder.decodeBuffer(privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.privateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException var6) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException var7) {
            throw new Exception("\u79c1\u94a5\u975e\u6cd5");
        }
        catch (IOException var8) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u5185\u5bb9\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException var9) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public byte[] encrypt(RSAPublicKey publicKey, byte[] plainTextData) throws Exception {
        if (publicKey == null) {
            throw new Exception("\u52a0\u5bc6\u516c\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            byte[] output = cipher.doFinal(plainTextData);
            return output;
        }
        catch (NoSuchAlgorithmException var5) {
            throw new Exception("\u65e0\u6b64\u52a0\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException var6) {
            var6.printStackTrace();
            return null;
        }
        catch (InvalidKeyException var7) {
            throw new Exception("\u52a0\u5bc6\u516c\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException var8) {
            throw new Exception("\u660e\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException var9) {
            throw new Exception("\u660e\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
    }

    public byte[] decrypt(RSAPrivateKey privateKey, byte[] cipherData) throws Exception {
        if (privateKey == null) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, privateKey);
            byte[] output = cipher.doFinal(cipherData);
            return output;
        }
        catch (NoSuchAlgorithmException var5) {
            throw new Exception("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException var6) {
            var6.printStackTrace();
            return null;
        }
        catch (InvalidKeyException var7) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException var8) {
            throw new Exception("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException var9) {
            throw new Exception("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
    }

    public static String byteArrayToString(byte[] data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            stringBuilder.append(HEX_CHAR[(data[i] & 0xF0) >>> 4]);
            stringBuilder.append(HEX_CHAR[data[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
        RSAEncryptUtil rsaEncrypt = new RSAEncryptUtil();
        try {
            rsaEncrypt.loadPublicKey(DEFAULT_PUBLIC_KEY);
            System.out.println("\u52a0\u8f7d\u516c\u94a5\u6210\u529f");
        }
        catch (Exception var11) {
            System.err.println(var11.getMessage());
            System.err.println("\u52a0\u8f7d\u516c\u94a5\u5931\u8d25");
        }
        try {
            rsaEncrypt.loadPrivateKey(DEFAULT_PRIVATE_KEY);
            System.out.println("\u52a0\u8f7d\u79c1\u94a5\u6210\u529f");
        }
        catch (Exception var10) {
            System.err.println(var10.getMessage());
            System.err.println("\u52a0\u8f7d\u79c1\u94a5\u5931\u8d25");
        }
        String encryptStr = "paymentID=698025500001506190912340001&userAccount=\u54aa\u5495\u52a8\u6f2b&payType=98&idEXT=1";
        try {
            byte[] cipher = rsaEncrypt.encrypt(rsaEncrypt.getPublicKey(), encryptStr.getBytes("utf-8"));
            System.out.println("\u5bc6\u6587\u957f\u5ea6:" + cipher.length);
            System.out.println("RSA\u52a0\u5bc6\u540e\uff1a" + new String(cipher));
            BASE64Encoder base64Encoder = new BASE64Encoder();
            String sign = new String(base64Encoder.encode(cipher));
            System.out.println("\u5bc6\u6587: " + sign);
            BASE64Decoder base64Decoder = new BASE64Decoder();
            byte[] buffer = base64Decoder.decodeBuffer(sign);
            byte[] plainText = rsaEncrypt.decrypt(rsaEncrypt.getPrivateKey(), buffer);
            System.out.println("\u660e\u6587\u957f\u5ea6:" + plainText.length);
            System.out.println(new String(plainText, "utf-8"));
        }
        catch (Exception var9) {
            System.err.println(var9.getMessage());
        }
    }

    public static String rsaEncryptBase64(String sign) {
        String signEncrypt = "";
        try {
            RSAEncryptUtil rsaEncrypt = new RSAEncryptUtil();
            rsaEncrypt.loadPublicKey(DEFAULT_PUBLIC_KEY);
            rsaEncrypt.loadPrivateKey(DEFAULT_PRIVATE_KEY);
            byte[] cipher = rsaEncrypt.encrypt(rsaEncrypt.getPublicKey(), sign.getBytes("utf-8"));
            BASE64Encoder base64Encoder = new BASE64Encoder();
            signEncrypt = new String(base64Encoder.encode(cipher));
            signEncrypt = URLEncoder.encode(signEncrypt, "UTF-8");
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return signEncrypt;
    }

    public static String getRSA(String sign) {
        String signEncrypt = "";
        try {
            RSAEncryptUtil rsaEncrypt = new RSAEncryptUtil();
            rsaEncrypt.loadPublicKey(DEFAULT_PUBLIC_KEY);
            rsaEncrypt.loadPrivateKey(DEFAULT_PRIVATE_KEY);
            byte[] cipher = rsaEncrypt.encrypt(rsaEncrypt.getPublicKey(), sign.getBytes("utf-8"));
            BASE64Encoder base64Encoder = new BASE64Encoder();
            signEncrypt = new String(base64Encoder.encode(cipher));
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return signEncrypt;
    }
}

