package com.ffcs.ebp.ebpsdk;

import com.ffcs.ebp.ebpsdk.common.Response;

import java.util.concurrent.Callable;

public class WithResult implements Callable<Response> {

    private String url;
    private String ak;
    private String sk;
    private String uuId;
    private String body;
    private String method;
    private int temp;
    private int connectTimeout;
    private int connectionRequestTimeout;
    private int socketTimeout;

    public WithResult(String url, String ak, String sk, String uuId, String body, String method, int temp, int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        this.url = url;
        this.ak = ak;
        this.sk = sk;
        this.uuId = uuId;
        this.body = body;
        this.method = method;
        this.temp = temp;
        this.connectTimeout = connectTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.socketTimeout = socketTimeout;
    }

    @Override
    public Response call() throws Exception {
        YunSign yunSign = new YunSign(url, ak, sk, uuId, body, temp);
        Response response = yunSign.toDo(method, connectTimeout, connectionRequestTimeout, socketTimeout);
        return response;
    }
}
