package com.ffcs.ebp.ebpsdk;

import com.ffcs.ebp.ebpsdk.common.Response;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import net.sf.json.JSONString;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.AuthSchemes;
import org.apache.http.client.config.CookieSpecs;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.*;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * @author zhoushq
 * @description
 * @date 2021/6/18
 * @time 17:00
 * 对ssl链接的证书验证
 */
public class YunSign {

    private String url;
    private String body;
    private String ak;
    private String sk;
    private String uuId;
    private int temp;

    public YunSign() {

    }

    public YunSign(String url, String ak, String sk, String uuId, String body,int temp) {
        this.url = url;
        this.body = body;
        this.ak = ak;
        this.sk = sk;
        this.uuId = uuId;
        this.temp = temp;
    }

    public Response toDo(String method, int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        Response response = null;

        method = method.toUpperCase();
        switch (method) {
            case "POST":
                response = doPost(connectTimeout, connectionRequestTimeout, socketTimeout);
                break;
            case "GET":
                response = doGet(connectTimeout, connectionRequestTimeout, socketTimeout);
                break;
            case "DELETE":
                response = doDelete(connectTimeout, connectionRequestTimeout, socketTimeout);
                break;
            case "PUT":
                response = doPut(connectTimeout, connectionRequestTimeout, socketTimeout);
                break;
            case "HEAD":
                response = doHead(connectTimeout, connectionRequestTimeout, socketTimeout);
                break;
        }
        return response;
    }

    private String getSign(Date eopDate) {
        String calculateContentHash = getSHA256(body); //报文原封不动进行sha256摘要

        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

        SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd");

        Date nowdate = new Date();

        String singerDate = TIME_FORMATTER.format(nowdate);

        String singerDd = DATE_FORMATTER.format(nowdate);

        //header的key按照26字母进行排序, 以&作为连接符连起来
        try {
            URL url = new URL(this.url);
//            String host = url.getHost();
//            String CampmocalHeader = String.format("eop-date:%s\nhost:%s\n", singerDate, host);
            String CampmocalHeader = String.format("ctyun-eop-request-id:%s\neop-date:%s\n", this.uuId, singerDate);
//            String path = url.getPath();
//            if (path == null || path.length() < 1)
//                path = "/";
//            if (path.charAt(path.length() - 1) != '/')
//                path = path + "/";

            String query = url.getQuery();
            String afterQuery = "";
            if (query != null) {
                String param[] = query.split("&");
                Arrays.sort(param);
                for (String str : param) {
                    if (afterQuery.length() < 1)
                        afterQuery = afterQuery + str;
                    else
                        afterQuery = afterQuery + "&" + str;
                }
            }


            String sigture = CampmocalHeader + "\n" + afterQuery + "\n" + calculateContentHash;


            String kSecret = sk;
            byte[] kheader = HmacSHA256(singerDate.getBytes(), kSecret.getBytes());
            byte[] kargs = HmacSHA256(ak.getBytes(), kheader);
            byte[] kbody = HmacSHA256(singerDd.getBytes(), kargs);

            String Signature = Base64.getEncoder().encodeToString(HmacSHA256(sigture.getBytes("UTF-8"), kbody));
//            String signHeader = String.format("%s Headers=eop-date;host Signature=%s", ak, Signature);
            String signHeader = String.format("%s Headers=ctyun-eop-request-id;eop-date Signature=%s", ak, Signature);
            return signHeader;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 在调用SSL之前需要重写验证方法，取消检测SSL
     * 创建ConnectionManager，添加Connection配置信息
     *
     * @return HttpClient 支持https
     */
    private static CloseableHttpClient sslClient() {
        try {
            // 在调用SSL之前需要重写验证方法，取消检测SSL
            X509TrustManager trustManager = new X509TrustManager() {
                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            SSLContext ctx = SSLContext.getInstance(SSLConnectionSocketFactory.TLS);
            ctx.init(null, new TrustManager[]{trustManager}, null);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(ctx, NoopHostnameVerifier.INSTANCE);
            // 创建Registry
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec(CookieSpecs.STANDARD_STRICT)
                    .setExpectContinueEnabled(Boolean.TRUE).setTargetPreferredAuthSchemes(Arrays.asList(AuthSchemes.NTLM, AuthSchemes.DIGEST))
                    .setProxyPreferredAuthSchemes(Arrays.asList(AuthSchemes.BASIC)).build();
            Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory>create()
                    .register("http", PlainConnectionSocketFactory.INSTANCE)
                    .register("https", socketFactory).build();
            // 创建ConnectionManager，添加Connection配置信息
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager(connectionManager)
                    .setDefaultRequestConfig(requestConfig).build();
            return closeableHttpClient;
        } catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        } catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }


    public Response doGet(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        Response result = new Response();
        try {
            // 通过址默认配置创建一个httpClient实例
            if(temp == 0){//绕过SSL
                httpClient = sslClient();
            }else{
                httpClient = HttpClients.createDefault();
            }
            // 创建httpGet远程连接实例
            HttpGet httpGet = new HttpGet(url);
            // 设置请求头信息，鉴权
            SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eopDate = new Date();
            httpGet.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpGet.setHeader("ctyun-eop-request-id", this.uuId);
            httpGet.setHeader("Eop-Authorization", getSign(eopDate));
            httpGet.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
            try {
                URL u = new URL(this.url);
                String host = u.getHost();
                httpGet.setHeader("Host", host);
            } catch (Exception e) {
            }

            System.out.println("请求头部 ----- ");
            for (Header header : httpGet.getAllHeaders()) {
                System.out.println(header.getName() + ":" + header.getValue());
            }
            System.out.println();
            // 设置配置请求参数
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(connectionRequestTimeout)// 请求超时时间
                    .setSocketTimeout(socketTimeout)// 数据读取超时时间
                    .build();
            // 为httpGet实例设置配置
            httpGet.setConfig(requestConfig);
            // 执行get请求得到返回对象
            response = httpClient.execute(httpGet);
            // 通过返回对象获取返回数据
            HttpEntity entity = response.getEntity();
            // 通过EntityUtils中的toString方法将结果转换为字符串
            result.setBody(EntityUtils.toString(entity));
            result.setStatusCode(response.getStatusLine().getStatusCode());
            Map<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);

        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            // 关闭资源
            if (null != response) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }


    public Response doPost(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {

        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        Response result = new Response();
        // 创建httpClient实例
        if(temp == 0){//绕过SSL
            httpClient = sslClient();
        }else{
            httpClient = HttpClients.createDefault();
        }

        // 创建httpPost远程连接实例
        HttpPost httpPost = new HttpPost(url);
        // 配置请求参数实例
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout)// 设置连接主机服务超时时间
                .setConnectionRequestTimeout(connectionRequestTimeout)// 设置连接请求超时时间
                .setSocketTimeout(socketTimeout)// 设置读取数据连接超时时间
                .build();
        // 为httpPost实例设置配置
        httpPost.setConfig(requestConfig);
        // 设置请求头
        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        Date eopDate = new Date();
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setHeader("ctyun-eop-request-id", this.uuId);
        httpPost.setHeader("Eop-Authorization", getSign(eopDate));
        httpPost.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
        try {
            URL u = new URL(this.url);
            String host = u.getHost();
            httpPost.setHeader("Host", host);
        } catch (Exception e) {
        }

        System.out.println("请求头部 ----- ");
        for (Header header : httpPost.getAllHeaders()) {
            System.out.println(header.getName() + ":" + header.getValue());
        }
        System.out.println();
        // 为httpPost设置封装好的请求参数
        try {
            StringEntity data = new StringEntity(body, Charset.forName("UTF-8"));
            httpPost.setEntity(data);
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            // httpClient对象执行post请求,并返回响应参数对象
            httpResponse = httpClient.execute(httpPost);

            // 从响应对象中获取响应内容
            HttpEntity entity = httpResponse.getEntity();
            result.setBody(EntityUtils.toString(entity));
            result.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            Map<String, String> headerMap = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);

        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            // 关闭资源
            if (null != httpResponse) {
                try {
                    httpResponse.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public Response doPut(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        Response result = new Response();
        // 创建httpClient实例
        if(temp == 0){//绕过SSL
            httpClient = sslClient();
        }else{
            httpClient = HttpClients.createDefault();
        }
        // 创建httpPost远程连接实例
        HttpPut httpPut = new HttpPut(url);
        // 配置请求参数实例
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout)// 设置连接主机服务超时时间
                .setConnectionRequestTimeout(connectionRequestTimeout)// 设置连接请求超时时间
                .setSocketTimeout(socketTimeout)// 设置读取数据连接超时时间
                .build();
        // 为httpPost实例设置配置
        httpPut.setConfig(requestConfig);
        // 设置请求头
        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        Date eopDate = new Date();
        httpPut.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPut.setHeader("ctyun-eop-request-id", this.uuId);
        httpPut.setHeader("Eop-Authorization", getSign(eopDate));
        httpPut.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
        try {
            URL u = new URL(this.url);
            String host = u.getHost();
            httpPut.setHeader("Host", host);
        } catch (Exception e) {
        }


        System.out.println("请求头部 ----- ");
        for (Header header : httpPut.getAllHeaders()) {
            System.out.println(header.getName() + ":" + header.getValue());
        }
        System.out.println();
        // 为httpPost设置封装好的请求参数
        try {
            StringEntity data = new StringEntity(body, Charset.forName("UTF-8"));
            httpPut.setEntity(data);
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            // httpClient对象执行post请求,并返回响应参数对象
            httpResponse = httpClient.execute(httpPut);
            // 从响应对象中获取响应内容
            HttpEntity entity = httpResponse.getEntity();
            result.setBody(EntityUtils.toString(entity));
            result.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            Map<String, String> headerMap = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            // 关闭资源
            if (null != httpResponse) {
                try {
                    httpResponse.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public Response doDelete(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        Response result = new Response();
        try {
            // 通过址默认配置创建一个httpClient实例
            if(temp == 0){//绕过SSL
                httpClient = sslClient();
            }else{
                httpClient = HttpClients.createDefault();
            }
            // 创建httpGet远程连接实例
            HttpDelete httpDelete = new HttpDelete(url);
            // 设置请求头信息，鉴权
            SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eopDate = new Date();
            httpDelete.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpDelete.setHeader("ctyun-eop-request-id", this.uuId);
            httpDelete.setHeader("Eop-Authorization", getSign(eopDate));
            httpDelete.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
            try {
                URL u = new URL(this.url);
                String host = u.getHost();
                httpDelete.setHeader("Host", host);
            } catch (Exception e) {
            }

            System.out.println("请求头部 ----- ");
            for (Header header : httpDelete.getAllHeaders()) {
                System.out.println(header.getName() + ":" + header.getValue());
            }
            System.out.println();
            // 设置配置请求参数
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(connectionRequestTimeout)// 请求超时时间
                    .setSocketTimeout(socketTimeout)// 数据读取超时时间
                    .build();
            // 为httpGet实例设置配置
            httpDelete.setConfig(requestConfig);
            // 执行get请求得到返回对象
            response = httpClient.execute(httpDelete);
            // 通过返回对象获取返回数据
            HttpEntity entity = response.getEntity();
            // 通过EntityUtils中的toString方法将结果转换为字符串
            result.setBody(EntityUtils.toString(entity));
            result.setStatusCode(response.getStatusLine().getStatusCode());
            Map<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            // 关闭资源
            if (null != response) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }


    public Response doHead(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        Response result = new Response();
        try {
            // 通过址默认配置创建一个httpClient实例
            if(temp == 0){//绕过SSL
                httpClient = sslClient();
            }else{
                httpClient = HttpClients.createDefault();
            }
            // 创建httpHead远程连接实例
            HttpHead httpHead = new HttpHead(url);
            // 设置请求头信息，鉴权
            SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eopDate = new Date();
            httpHead.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpHead.setHeader("ctyun-eop-request-id", this.uuId);
            httpHead.setHeader("Eop-Authorization", getSign(eopDate));
            httpHead.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
            try {
                URL u = new URL(this.url);
                String host = u.getHost();
                httpHead.setHeader("Host", host);
            } catch (Exception e) {
            }

            System.out.println("请求头部 ----- ");
            for (Header header : httpHead.getAllHeaders()) {
                System.out.println(header.getName() + ":" + header.getValue());
            }
            System.out.println();
            // 设置配置请求参数
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout)// 连接主机服务超时时间
                    .setConnectionRequestTimeout(connectionRequestTimeout)// 请求超时时间
                    .setSocketTimeout(socketTimeout)// 数据读取超时时间
                    .build();
            // 为httpHead实例设置配置
            httpHead.setConfig(requestConfig);
            // 执行head请求得到返回对象
            response = httpClient.execute(httpHead);
            // 通过返回对象获取返回数据
            HttpEntity entity = response.getEntity();
            // 通过EntityUtils中的toString方法将结果转换为字符串
            if (entity != null) {
                result.setBody(EntityUtils.toString(entity));
            }
            result.setStatusCode(response.getStatusLine().getStatusCode());
            Map<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            // 关闭资源
            if (null != response) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        byte[] var2 = data;
        int var3 = data.length;

        for (int var4 = 0; var4 < var3; ++var4) {
            byte b = var2[var4];
            String hex = Integer.toHexString(b);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }

            sb.append(hex);
        }

        return sb.toString().toLowerCase(Locale.getDefault());
    }

    private String getSHA256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return toHex(md.digest());
        } catch (NoSuchAlgorithmException var3) {
            return null;
        }
        //return new byte[1];
    }


    private byte[] HmacSHA256(byte[] data, byte[] key) throws Exception {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(data);
        } catch (Exception e) {
            return null;
        }
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

}
