package com.ffcs.ebp.ebpsdk.security;

import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
   private static final String ALGORITHM = "AES";
   private static String iv = "fedcba9876543210";
   private static final String KEY = "ebp-2016";
   private static final String HEX = "0123456789ABCDEF";

   public static String cipher(String secretKey, String data) throws Exception {
      SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
      KeySpec spec = new PBEKeySpec(secretKey.toCharArray(), secretKey.getBytes(), 128, 128);
      SecretKey tmp = factory.generateSecret(spec);
      SecretKey key = new SecretKeySpec(tmp.getEncoded(), "AES");
      Cipher cipher = Cipher.getInstance("AES");
      new IvParameterSpec(iv.getBytes());
      cipher.init(1, key);
      return toHex(cipher.doFinal(data.getBytes()));
   }

   public static String decipher(String data) throws Exception {
      return decipher("ebp-2016", data);
   }

   public static String decipher(String secretKey, String data) throws Exception {
      SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
      KeySpec spec = new PBEKeySpec(secretKey.toCharArray(), secretKey.getBytes(), 128, 128);
      SecretKey tmp = factory.generateSecret(spec);
      SecretKey key = new SecretKeySpec(tmp.getEncoded(), "AES");
      Cipher cipher = Cipher.getInstance("AES");
      new IvParameterSpec(iv.getBytes());
      cipher.init(2, key);
      return new String(cipher.doFinal(toByte(data)));
   }

   public static String encrypt(String seed, String cleartext) {
      try {
         return cipher(seed, cleartext);
      } catch (Exception var3) {
         var3.printStackTrace();
         return null;
      }
   }

   public static String decrypt(String seed, String encrypted) {
      try {
         return decipher(seed, encrypted);
      } catch (Exception var3) {
         var3.printStackTrace();
         return null;
      }
   }

   public static String encrypt2(String seed, String cleartext) {
      try {
         byte[] result = encrypt(seed.getBytes(), cleartext.getBytes());
         return toHex(result);
      } catch (Exception var4) {
         var4.printStackTrace();
         return null;
      }
   }

   public static String decrypt2(String seed, String encrypted) {
      try {
         byte[] enc = toByte(encrypted);
         byte[] result = decrypt(seed.getBytes(), enc);
         return new String(result);
      } catch (Exception var5) {
         var5.printStackTrace();
         return null;
      }
   }

   private static byte[] encrypt(byte[] raw, byte[] clear) throws Exception {
      new IvParameterSpec(iv.getBytes());
      SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
      Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding", "BC");
      cipher.init(1, skeySpec);
      byte[] encrypted = cipher.doFinal(clear);
      return encrypted;
   }

   private static byte[] decrypt(byte[] raw, byte[] encrypted) throws Exception {
      new IvParameterSpec(iv.getBytes());
      SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
      Cipher cipher = Cipher.getInstance("AES/CFB/PKCS5Padding", "BC");
      cipher.init(2, skeySpec);
      byte[] decrypted = cipher.doFinal(encrypted);
      return decrypted;
   }

   public static String toHex(String txt) {
      return toHex(txt.getBytes());
   }

   public static String fromHex(String hex) {
      return new String(toByte(hex));
   }

   public static byte[] toByte(String hexString) {
      int len = hexString.length() / 2;
      byte[] result = new byte[len];

      for(int i = 0; i < len; ++i) {
         result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
      }

      return result;
   }

   public static String toHex(byte[] buf) {
      if (buf == null) {
         return "";
      } else {
         StringBuffer result = new StringBuffer(2 * buf.length);

         for(int i = 0; i < buf.length; ++i) {
            appendHex(result, buf[i]);
         }

         return result.toString();
      }
   }

   private static void appendHex(StringBuffer sb, byte b) {
      sb.append("0123456789ABCDEF".charAt(b >> 4 & 15)).append("0123456789ABCDEF".charAt(b & 15));
   }

   public static String encrypt(String data) {
      return encrypt("ebp-2016", data);
   }

   public static String decrypt(String encrypted) {
      return decrypt("ebp-2016", encrypted);
   }

   public static void main(String[] args) throws Exception {
      String content = "user@ffcs";
      System.out.println("开始时间" + System.currentTimeMillis());
      System.out.println("加密后：" + encrypt(content));
      System.out.println("解密后：" + decrypt(encrypt(content)));
      System.out.println("结束时间" + System.currentTimeMillis());
   }
}
