package com.ffcs.ebp.ebpsdk.security;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class UUIDUtils {
   private static long b = 1180000000000L;
   private static long seedUniquifier;
   private static final int DEFAULT_RADIX = 36;
   private static final String[] letters;

   public static String getUniqueId(int length, int radix) {
      ++seedUniquifier;
      String uniqueId = Long.toString(seedUniquifier, radix);
      int initialLength = uniqueId.length();
      int leftLength = initialLength - length;
      if (leftLength > 0) {
         uniqueId = uniqueId.substring(leftLength, initialLength);
      } else if (leftLength < 0) {
         StringBuilder buffer;
         for(buffer = new StringBuilder(); leftLength < 0; ++leftLength) {
            String rand = rand();
            buffer.append(rand);
         }

         buffer.append(uniqueId);
         uniqueId = buffer.toString();
      }

      return uniqueId;
   }

   public static String getUniqueId(int length) {
      return getUniqueId(length, 36);
   }

   public static String getUniqueId() {
      return getUniqueId(8);
   }

   public static String uuid() {
      String uuid = UUID.randomUUID().toString();
      return uuid.replaceAll("-", "");
   }

   public static String rand() {
      int random = RandomFactory.nextInt();
      int index = Math.abs(random % 62);
      return letters[index];
   }

   public static int getRand(int length) {
      int random = RandomFactory.getInstance().nextInt();
      int index = Math.abs(random % length);
      return index;
   }

   public static String generateRandom(int length) {
      int i = 0;

      String result;
      for(result = ""; i < length; ++i) {
         String random = String.valueOf(getRand(10));
         result = result + random;
      }

      return result;
   }

   public static String randomMorningTime(int t) {
      StringBuffer sb = new StringBuffer();
      if (t == 0) {
         int left = myRandom(0, 1);
         sb.append(left);
         if (left == 0) {
            sb.append("9");
         }

         if (left == 1) {
            sb.append("0");
         }
      }

      if (t == 1) {
         sb.append("1");
         sb.append(myRandom(1, 2));
      }

      if (t == 2) {
         sb.append(myRandom(17, 18));
      }

      sb.append(":");
      sb.append(myRandom(0, 5));
      sb.append(myRandom(0, 9));
      return sb.toString();
   }

   public static int myRandom(int m, int n) {
      if (m > n) {
         return 0;
      } else {
         int reVal = (int)(RandomFactory.nextDouble() * (double)(n - m + 1)) + m;
         return reVal;
      }
   }

   public static String getRandomTime(String beginTime, String endTime) {
      String date = "";

      try {
         Date beginDate = null;
         Date endDate = null;
         if (beginTime.length() == 10) {
            beginDate = (new SimpleDateFormat("yyyy-MM-dd")).parse(beginTime);
            endDate = (new SimpleDateFormat("yyyy-MM-dd")).parse(endTime);
         } else {
            beginDate = (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(beginTime);
            endDate = (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(endTime);
         }

         long le = endDate.getTime();
         long lb = beginDate.getTime();
         long random = Math.round(RandomFactory.nextDouble() * (double)(le - lb) + (double)lb);
         SimpleDateFormat fm1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         date = fm1.format(random);
      } catch (Exception var12) {
      }

      return date;
   }

   public static String randXXXnumber(int length) {
      StringBuffer sb = new StringBuffer();
      if (length > 0) {
         for(int i = 0; i < length; ++i) {
            sb.append((char)randInt(48, 57));
         }
      }

      return sb.toString();
   }

   private static int randInt() {
      return RandomFactory.nextInt();
   }

   private static int randInt(int start, int end) {
      if (start > end) {
         swap(start, end);
      }

      return Math.abs(randInt() % (end - start + 1)) + start;
   }

   private static void swap(int a, int b) {
   }

   static {
      seedUniquifier = System.currentTimeMillis() - b;
      letters = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
   }
}
