package com.ffcs.ebp.ebpsdk;

import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 说  明：
 * 作  者：zf.zeng
 * 日  期：2020-04-08 (星期三)
 **/
public class EbpContext {
    private final String protocols = "http://";
    private String requestUrl;
    private String clientIp = HttpRequest.getLocalHostLANAddress().getHostAddress();
    private String params;
    private List<Header> headers = new ArrayList<Header>();

    EbpContext(){}

    public EbpContext(String url, Header... headers) {
        this.requestUrl = url;
        this.headers.addAll(Arrays.asList(headers));
    }

    public EbpContext(String url, List<Header> headers) {
        this.requestUrl = url;
        this.headers = headers;
    }

    String getClientIp() {
        if (StringUtils.isBlank(this.clientIp)) throw new RuntimeException("ORIG_CLIENT_IP不能为空！");
        if (!this.isIP(this.clientIp)) throw new RuntimeException("ORIG_CLIENT_IP,格式错误！");
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getParams() {
        try {
            if (StringUtils.isBlank(this.params)) throw new RuntimeException("请求报文不能为空！");
            JSONObject.fromObject(this.params);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("请求报文格式必须为Json格式");
        }
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public List<Header> getHeaders() {
        return headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    private boolean isIP(String addr) {
        if (StringUtils.isNotBlank(addr) && addr.length() >= 7 && addr.length() <= 15) {
            String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
            Pattern pat = Pattern.compile(rexp);
            Matcher mat = pat.matcher(addr);
            return mat.find();
        } else {
            return false;
        }
    }

    String getRequestUrl(){
        if(StringUtils.isBlank(this.requestUrl)) throw new  NullPointerException("API地址不能为空");
        return requestUrl.endsWith("/")? requestUrl: requestUrl.concat("/");
    }
}
