package com.ffcs.ebp.ebpsdk;

import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import java.io.*;
import java.net.*;
import java.util.Enumeration;
import java.util.List;

public class HttpRequest {

    public static String sendGet(String url, String param, List<Header> headers) {
        StringBuilder result = new StringBuilder();
        BufferedReader in = null;
        HttpURLConnection connection = null;
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank(param)) {
            JSONObject object = JSONObject.fromObject(param);
            for (Object key : object.keySet()) {
                builder = builder.length() == 0 ? builder.append("?") : builder.append("&");
                builder.append(key).append("=").append(object.get(key));
            }
        }
        try {
            String urlNameString = url + builder.toString();
            URL realUrl = new URL(urlNameString);
            connection = (HttpURLConnection) realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestProperty("SOAPAction", "");
            connection.setRequestProperty("User-Agent", "Apache-HttpClient/4.5.6 (Java/1.8.0_192)");
            connection.setConnectTimeout(10000);
            for (Header header : headers) connection.setRequestProperty(header.getKey(), header.getValue());

            headers.clear();
            for (String key:  connection.getRequestProperties().keySet()) {
                String val = connection.getRequestProperties().get(key).get(0);
                headers.add(new Header(key, StringUtils.isBlank(val)? "": val));
            }

            connection.connect();

            String line;
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) result.append(line);
        } catch (Exception e) {
            result = new StringBuilder("报文GET发送失败：" + e.getMessage());
            e.printStackTrace();
        } finally {
            try {
                if (in != null) in.close();
                if (connection != null) connection.disconnect();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    /**
     * POST请求
     *
     * @param requestUrl 请求地址
     * @param param      请求数据/
     */
    public static String sendPost(String requestUrl, String param, List<Header> headers) {

        HttpURLConnection connection = null;
        InputStream is = null;
        OutputStream os = null;
        BufferedReader br = null;
        StringBuilder result = new StringBuilder();

        try {
            URL url = new URL(requestUrl);

            connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            // 默认值为：false，当向远程服务器传送数据/写数据时，需要设置为true
            connection.setDoOutput(true);
            // 默认值为：true，当前向远程服务读取数据时，设置为true，该参数可有可无
            connection.setDoInput(true);
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            // 'Content-Type': 'application/x-www-form-urlencoded' 设置传入参数的格式:请求参数应该是 name1=value1&name2=value2 的形式
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestProperty("User-Agent", "Apache-HttpClient/4.5.6 (Java/1.8.0_192)");

            for (Header header : headers) connection.setRequestProperty(header.getKey(), header.getValue());

            headers.clear();
            for (String key:  connection.getRequestProperties().keySet()) {
                String val = connection.getRequestProperties().get(key).get(0);
                headers.add(new Header(key, StringUtils.isBlank(val)? "": val));
            }

            os = connection.getOutputStream();
            if (StringUtils.isNotBlank(param)) {
                os.write(param.getBytes());
            }
            is = connection.getInputStream();
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line;
            while ((line = br.readLine()) != null) result.append(line);
        } catch (Exception e) {
            result = new StringBuilder("报文POST发送失败：" + e.getMessage());
            e.printStackTrace();
        } finally {
            try {

                if (null != br) br.close();

                if (null != is) is.close();

                if (null != os)  os.close();


                // 关闭远程连接
                // 断开连接，最好写上，disconnect是在底层tcp socket链接空闲时才切断。如果正在被其他线程使用就不切断。
                // 固定多线程的话，如果不disconnect，链接会增多，直到收发不出信息。写上disconnect后正常一些
                if (null != connection) connection.disconnect();

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    static InetAddress getLocalHostLANAddress() {
        try {
            InetAddress candidateAddress = null;
            Enumeration ifaces = NetworkInterface.getNetworkInterfaces();

            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = (NetworkInterface) ifaces.nextElement();
                Enumeration inetAddrs = iface.getInetAddresses();

                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = (InetAddress) inetAddrs.nextElement();
                    if (!inetAddr.isLoopbackAddress()) {
                        if (inetAddr.isSiteLocalAddress()) {
                            return inetAddr;
                        }

                        if (candidateAddress == null) {
                            candidateAddress = inetAddr;
                        }
                    }
                }
            }

            if (candidateAddress != null) {
                return candidateAddress;
            } else {
                return InetAddress.getLocalHost();
            }
        } catch (Exception var5) {
            var5.printStackTrace();
            return null;
        }
    }
}
