package com.ffcs.ebp.ebpsdk.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class AuthBase64Utils {
   private static final int CACHE_SIZE = 1024;

   public static byte[] decode(String base64) throws Exception {
      return AuthBase64.decode(base64);
   }

   public static String encode(byte[] bytes) throws Exception {
      return new String(AuthBase64.encode(bytes));
   }

   public static String encodeFile(String filePath) throws Exception {
      byte[] bytes = fileToByte(filePath);
      return encode(bytes);
   }

   public static void decodeToFile(String filePath, String base64) throws Exception {
      byte[] bytes = decode(base64);
      byteArrayToFile(bytes, filePath);
   }

   public static byte[] fileToByte(String filePath) throws Exception {
      byte[] data = new byte[0];
      File file = new File(filePath);
      if (file.exists()) {
         FileInputStream in = null;
         ByteArrayOutputStream out = null;

         try {
            in = new FileInputStream(file);
            out = new ByteArrayOutputStream(2048);
            byte[] cache = new byte[1024];
            boolean var6 = false;

            int nRead;
            while((nRead = in.read(cache)) != -1) {
               out.write(cache, 0, nRead);
               out.flush();
            }

            data = out.toByteArray();
         } catch (Exception var17) {
            throw var17;
         } finally {
            if (out != null) {
               try {
                  out.close();
               } catch (Exception var16) {
                  var16.printStackTrace();
               }
            }

            if (in != null) {
               try {
                  in.close();
               } catch (Exception var15) {
                  var15.printStackTrace();
               }
            }

         }
      }

      return data;
   }

   public static void byteArrayToFile(byte[] bytes, String filePath) throws Exception {
      InputStream in = null;
      FileOutputStream out = null;

      try {
         in = new ByteArrayInputStream(bytes);
         File destFile = new File(filePath);
         if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
         }

         destFile.createNewFile();
         out = new FileOutputStream(destFile);
         byte[] cache = new byte[1024];
         boolean var6 = false;

         int nRead;
         while((nRead = in.read(cache)) != -1) {
            out.write(cache, 0, nRead);
            out.flush();
         }
      } catch (Exception var17) {
         throw var17;
      } finally {
         if (in != null) {
            try {
               in.close();
            } catch (Exception var16) {
               var16.printStackTrace();
            }
         }

         if (out != null) {
            try {
               out.close();
            } catch (Exception var15) {
               var15.printStackTrace();
            }
         }

      }

      out.close();
      in.close();
   }
}
