package com.ffcs.ebp.ebpsdk.security;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.BASE64Encoder;

public class DESUtils {
   private static final String encoding = "utf-8";

   public static String encode(String plainText, String ivKey, String key) {
      Key deskey = null;
      Object var4 = null;

      try {
         DESedeKeySpec spec = new DESedeKeySpec(key.getBytes());
         SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("desede");
         deskey = keyfactory.generateSecret(spec);
         Cipher cipher = Cipher.getInstance("desede/CBC/PKCS5Padding");
         IvParameterSpec ips = new IvParameterSpec(ivKey.getBytes());
         cipher.init(1, deskey, ips);
         byte[] encryptData = cipher.doFinal(plainText.getBytes("utf-8"));
         BASE64Encoder base64Encoder = new BASE64Encoder();
         return base64Encoder.encode(encryptData);
      } catch (Exception var10) {
         var10.printStackTrace();
         return "";
      }
   }

   public static String decode(String plainText, String ivKey, String key) {
      Key deskey = null;
      Object var4 = null;

      try {
         byte[] byteMi = Base64.decode(plainText);
         DESedeKeySpec spec = new DESedeKeySpec(key.getBytes());
         SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("desede");
         deskey = keyfactory.generateSecret(spec);
         Cipher cipher = Cipher.getInstance("desede/CBC/PKCS5Padding");
         IvParameterSpec ips = new IvParameterSpec(ivKey.getBytes());
         cipher.init(2, deskey, ips);
         byte[] encryptData = cipher.doFinal(byteMi);
         return new String(encryptData, "UTF8");
      } catch (Exception var10) {
         var10.printStackTrace();
         return "";
      }
   }

   public static String initKey() {
      SecureRandom sr = new SecureRandom();
      KeyGenerator kg = null;

      try {
         kg = KeyGenerator.getInstance("DESede");
         kg.init(sr);
         SecretKey key = kg.generateKey();
         byte[] bys = key.getEncoded();
         String publicKeyValue = (new BASE64Encoder()).encode(bys);
         return publicKeyValue;
      } catch (NoSuchAlgorithmException var5) {
         var5.printStackTrace();
         return "";
      }
   }

   public static String getStringRandom(int length) {
      String val = "";

      for(int i = 0; i < length; ++i) {
         String charOrNum = RandomFactory.nextInt(2) % 2 == 0 ? "char" : "num";
         if ("char".equalsIgnoreCase(charOrNum)) {
            int temp = RandomFactory.nextInt(2) % 2 == 0 ? 65 : 97;
            val = val + (char)(RandomFactory.getInstance().nextInt(26) + temp);
         } else if ("num".equalsIgnoreCase(charOrNum)) {
            val = val + String.valueOf(RandomFactory.nextInt(10));
         }
      }

      return val;
   }

   public static void main(String[] args) {
      String randomStr = getStringRandom(26);
      System.out.println(randomStr);
   }

   public static String singleDesEncrypt(String plainText, String ivKey, String key) {
      try {
         DESKeySpec ks = new DESKeySpec(key.getBytes("UTF-8"));
         SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
         SecretKey sk = skf.generateSecret(ks);
         Cipher cip = Cipher.getInstance("DES/CBC/PKCS5Padding");
         IvParameterSpec ivp = new IvParameterSpec(ivKey.getBytes());
         cip.init(1, sk, ivp);
         return bytesToHexString(cip.doFinal(plainText.getBytes("GBK")));
      } catch (Exception var8) {
         System.out.println("单DES加密字符串失败：" + var8);
         return "加密字符串失败!";
      }
   }

   public static String singleDesDecrypt(String plainText, String ivKey, String key) {
      try {
         byte[] data = hexStringToByte(plainText);
         DESKeySpec dks = new DESKeySpec(key.getBytes());
         SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
         SecretKey secretKey = keyFactory.generateSecret(dks);
         Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
         IvParameterSpec ivp = new IvParameterSpec(ivKey.getBytes());
         cipher.init(2, secretKey, ivp);
         byte[] decryptedData = cipher.doFinal(data);
         return new String(decryptedData, "GBK");
      } catch (Exception var10) {
         System.out.println("单DES解密字符串失败："+ var10);
         return "解密字符串失败!";
      }
   }

   public static final String bytesToHexString(byte[] bArray) {
      StringBuffer sb = new StringBuffer(bArray.length);

      for(int i = 0; i < bArray.length; ++i) {
         String sTemp = Integer.toHexString(255 & bArray[i]);
         if (sTemp.length() < 2) {
            sb.append(0);
         }

         sb.append(sTemp.toUpperCase());
      }

      return sb.toString();
   }

   public static byte[] hexStringToByte(String hex) {
      int len = hex.length() / 2;
      byte[] result = new byte[len];
      char[] achar = hex.toCharArray();

      for(int i = 0; i < len; ++i) {
         int pos = i * 2;
         result[i] = (byte)(toByte(achar[pos]) << 4 | toByte(achar[pos + 1]));
      }

      return result;
   }

   private static int toByte(char c) {
      byte b = (byte)"0123456789ABCDEF".indexOf(c);
      return b;
   }
}
