package com.ffcs.ebp.ebpsdk.security;

public final class QuickLZ {
   public static final int QLZ_STREAMING_BUFFER = 0;
   public static final int QLZ_MEMORY_SAFE = 0;
   public static final int QLZ_VERSION_MAJOR = 1;
   public static final int QLZ_VERSION_MINOR = 5;
   public static final int QLZ_VERSION_REVISION = 0;
   private static final int HASH_VALUES = 4096;
   private static final int MINOFFSET = 2;
   private static final int UNCONDITIONAL_MATCHLEN = 6;
   private static final int UNCOMPRESSED_END = 4;
   private static final int CWORD_LEN = 4;
   private static final int DEFAULT_HEADERLEN = 9;
   private static final int QLZ_POINTERS_1 = 1;
   private static final int QLZ_POINTERS_3 = 16;

   static int headerLen(byte[] source) {
      return (source[0] & 2) == 2 ? 9 : 3;
   }

   public static long sizeDecompressed(byte[] source) {
      return headerLen(source) == 9 ? fast_read(source, 5, 4) : fast_read(source, 2, 1);
   }

   public static long sizeCompressed(byte[] source) {
      return headerLen(source) == 9 ? fast_read(source, 1, 4) : fast_read(source, 1, 1);
   }

   private static void write_header(byte[] dst, int level, boolean compressible, int size_compressed, int size_decompressed) {
      dst[0] = (byte)(2 | (compressible ? 1 : 0));
      dst[0] |= (byte)(level << 2);
      dst[0] = (byte)(dst[0] | 64);
      dst[0] = (byte)(dst[0] | 0);
      fast_write(dst, 1, (long)size_decompressed, 4);
      fast_write(dst, 5, (long)size_compressed, 4);
   }

   public static byte[] compress(byte[] source, int level) {
      int src = 0;
      int dst = 13;
      long cword_val = 2147483648L;
      int cword_ptr = 9;
      byte[] destination = new byte[source.length + 400];
      int[] cachetable = new int[4096];
      byte[] hash_counter = new byte[4096];
      int fetch = 0;
      int last_matchstart = source.length - 6 - 4 - 1;
      int lits = 0;
      if (level != 1 && level != 3) {
         throw new RuntimeException("Java version only supports level 1 and 3");
      } else {
         int[][] hashtable;
         if (level == 1) {
            hashtable = new int[4096][1];
         } else {
            hashtable = new int[4096][16];
         }

         if (source.length == 0) {
            return new byte[0];
         } else {
            if (src <= last_matchstart) {
               fetch = (int)fast_read(source, src, 3);
            }

            byte[] d2;
            while(src <= last_matchstart) {
               if ((cword_val & 1L) == 1L) {
                  if (src > 3 * (source.length >> 2) && dst > src - (src >> 5)) {
                     d2 = new byte[source.length + 9];
                     write_header(d2, level, false, source.length, source.length + 9);
                     System.arraycopy(source, 0, d2, 9, source.length);
                     return d2;
                  }

                  fast_write(destination, cword_ptr, cword_val >>> 1 | 2147483648L, 4);
                  cword_ptr = dst;
                  dst += 4;
                  cword_val = 2147483648L;
               }

               int o;
               int offset2;
               int matchlen;
               int old_src;
               int m;
               if (level == 1) {
                  o = (fetch >>> 12 ^ fetch) & 4095;
                  offset2 = hashtable[o][0];
                  matchlen = cachetable[o] ^ fetch;
                  cachetable[o] = fetch;
                  hashtable[o][0] = src;
                  if (matchlen != 0 || hash_counter[o] == 0 || src - offset2 <= 2 && (src != offset2 + 1 || lits < 3 || src <= 3 || source[src] != source[src - 3] || source[src] != source[src - 2] || source[src] != source[src - 1] || source[src] != source[src + 1] || source[src] != source[src + 2])) {
                     ++lits;
                     hash_counter[o] = 1;
                     destination[dst] = source[src];
                     cword_val >>>= 1;
                     ++src;
                     ++dst;
                     fetch = fetch >>> 8 & '\uffff' | (source[src + 2] & 255) << 16;
                  } else {
                     cword_val = cword_val >>> 1 | 2147483648L;
                     if (source[offset2 + 3] != source[src + 3]) {
                        old_src = 1 | o << 4;
                        destination[dst + 0] = (byte)(old_src >>> 0);
                        destination[dst + 1] = (byte)(old_src >>> 8);
                        src += 3;
                        dst += 2;
                     } else {
                        old_src = src;
                        m = source.length - 4 - src + 1 - 1 > 255 ? 255 : source.length - 4 - src + 1 - 1;
                        src += 4;
                        if (source[offset2 + src - old_src] == source[src]) {
                           ++src;
                           if (source[offset2 + src - old_src] == source[src]) {
                              ++src;

                              while(source[offset2 + (src - old_src)] == source[src] && src - old_src < m) {
                                 ++src;
                              }
                           }
                        }

                        matchlen = src - old_src;
                        o <<= 4;
                        int f;
                        if (matchlen < 18) {
                           f = o | matchlen - 2;
                           destination[dst + 0] = (byte)(f >>> 0);
                           destination[dst + 1] = (byte)(f >>> 8);
                           dst += 2;
                        } else {
                           f = o | matchlen << 16;
                           fast_write(destination, dst, (long)f, 3);
                           dst += 3;
                        }
                     }

                     lits = 0;
                     fetch = (int)fast_read(source, src, 3);
                  }
               } else {
                  fetch = (int)fast_read(source, src, 3);
                  boolean best_k = false;
                  int remaining = source.length - 4 - src + 1 - 1 > 255 ? 255 : source.length - 4 - src + 1 - 1;
                  int hash = (fetch >>> 12 ^ fetch) & 4095;
                  byte c = hash_counter[hash];
                  matchlen = 0;
                  offset2 = 0;

                  for(old_src = 0; old_src < 16 && (c > old_src || c < 0); ++old_src) {
                     o = hashtable[hash][old_src];
                     if ((byte)fetch == source[o] && (byte)(fetch >>> 8) == source[o + 1] && (byte)(fetch >>> 16) == source[o + 2] && o < src - 2) {
                        for(m = 3; source[o + m] == source[src + m] && m < remaining; ++m) {
                        }

                        if (m > matchlen || m == matchlen && o > offset2) {
                           offset2 = o;
                           matchlen = m;
                        }
                     }
                  }

                  hashtable[hash][c & 15] = src;
                  ++c;
                  hash_counter[hash] = c;
                  if (matchlen >= 3 && src - offset2 < 131071) {
                     int offset = src - offset2;

                     for(int u = 1; u < matchlen; ++u) {
                        fetch = (int)fast_read(source, src + u, 3);
                        hash = (fetch >>> 12 ^ fetch) & 4095;
                        c = hash_counter[hash]++;
                        hashtable[hash][c & 15] = src + u;
                     }

                     src += matchlen;
                     cword_val = cword_val >>> 1 | 2147483648L;
                     if (matchlen == 3 && offset <= 63) {
                        fast_write(destination, dst, (long)(offset << 2), 1);
                        ++dst;
                     } else if (matchlen == 3 && offset <= 16383) {
                        fast_write(destination, dst, (long)(offset << 2 | 1), 2);
                        dst += 2;
                     } else if (matchlen <= 18 && offset <= 1023) {
                        fast_write(destination, dst, (long)(matchlen - 3 << 2 | offset << 6 | 2), 2);
                        dst += 2;
                     } else if (matchlen <= 33) {
                        fast_write(destination, dst, (long)(matchlen - 2 << 2 | offset << 7 | 3), 3);
                        dst += 3;
                     } else {
                        fast_write(destination, dst, (long)(matchlen - 3 << 7 | offset << 15 | 3), 4);
                        dst += 4;
                     }
                  } else {
                     destination[dst] = source[src];
                     cword_val >>>= 1;
                     ++src;
                     ++dst;
                  }
               }
            }

            while(src <= source.length - 1) {
               if ((cword_val & 1L) == 1L) {
                  fast_write(destination, cword_ptr, cword_val >>> 1 | 2147483648L, 4);
                  cword_ptr = dst;
                  dst += 4;
                  cword_val = 2147483648L;
               }

               destination[dst] = source[src];
               ++src;
               ++dst;
               cword_val >>>= 1;
            }

            while((cword_val & 1L) != 1L) {
               cword_val >>>= 1;
            }

            fast_write(destination, cword_ptr, cword_val >>> 1 | 2147483648L, 4);
            write_header(destination, level, true, source.length, dst);
            d2 = new byte[dst];
            System.arraycopy(destination, 0, d2, 0, dst);
            return d2;
         }
      }
   }

   static long fast_read(byte[] a, int i, int numbytes) {
      long l = 0L;

      for(int j = 0; j < numbytes; ++j) {
         l |= ((long)a[i + j] & 255L) << j * 8;
      }

      return l;
   }

   static void fast_write(byte[] a, int i, long value, int numbytes) {
      for(int j = 0; j < numbytes; ++j) {
         a[i + j] = (byte)((int)(value >>> j * 8));
      }

   }

   public static byte[] decompress(byte[] source) throws Exception {
      int size = (int)sizeDecompressed(source);
      int src = headerLen(source);
      int dst = 0;
      long cword_val = 1L;
      byte[] destination = new byte[size];
      int[] hashtable = new int[4096];
      byte[] hash_counter = new byte[4096];
      int last_matchstart = size - 6 - 4 - 1;
      int last_hashed = -1;
      int fetch = 0;
      int level = source[0] >>> 2 & 3;
      if (level != 1 && level != 3) {
         throw new RuntimeException("Java version only supports level 1 and 3 , The level " + level);
      } else if ((source[0] & 1) != 1) {
         byte[] d2 = new byte[size];
         System.arraycopy(source, headerLen(source), d2, 0, size);
         return d2;
      } else {
         while(true) {
            while(true) {
               if (cword_val == 1L) {
                  cword_val = fast_read(source, src, 4);
                  src += 4;
                  if (dst <= last_matchstart) {
                     if (level == 1) {
                        fetch = (int)fast_read(source, src, 3);
                     } else {
                        fetch = (int)fast_read(source, src, 4);
                     }
                  }
               }

               int hash;
               int matchlen;
               if ((cword_val & 1L) == 1L) {
                  cword_val >>>= 1;
                  int offset2;
                  int offset;
                  if (level == 1) {
                     hash = fetch >>> 4 & 4095;
                     offset2 = hashtable[hash];
                     if ((fetch & 15) != 0) {
                        matchlen = (fetch & 15) + 2;
                        src += 2;
                     } else {
                        matchlen = source[src + 2] & 255;
                        src += 3;
                     }
                  } else {
                     if ((fetch & 3) == 0) {
                        offset = (fetch & 255) >>> 2;
                        matchlen = 3;
                        ++src;
                     } else if ((fetch & 2) == 0) {
                        offset = (fetch & '\uffff') >>> 2;
                        matchlen = 3;
                        src += 2;
                     } else if ((fetch & 1) == 0) {
                        offset = (fetch & '\uffff') >>> 6;
                        matchlen = (fetch >>> 2 & 15) + 3;
                        src += 2;
                     } else if ((fetch & 127) != 3) {
                        offset = fetch >>> 7 & 131071;
                        matchlen = (fetch >>> 2 & 31) + 2;
                        src += 3;
                     } else {
                        offset = fetch >>> 15;
                        matchlen = (fetch >>> 7 & 255) + 3;
                        src += 4;
                     }

                     offset2 = dst - offset;
                  }

                  destination[dst + 0] = destination[offset2 + 0];
                  destination[dst + 1] = destination[offset2 + 1];
                  destination[dst + 2] = destination[offset2 + 2];

                  for(offset = 3; offset < matchlen; ++offset) {
                     destination[dst + offset] = destination[offset2 + offset];
                  }

                  dst += matchlen;
                  if (level != 1) {
                     fetch = (int)fast_read(source, src, 4);
                  } else {
                     for(fetch = (int)fast_read(destination, last_hashed + 1, 3); last_hashed < dst - matchlen; fetch = fetch >>> 8 & '\uffff' | (destination[last_hashed + 3] & 255) << 16) {
                        ++last_hashed;
                        hash = (fetch >>> 12 ^ fetch) & 4095;
                        hashtable[hash] = last_hashed;
                        hash_counter[hash] = 1;
                     }

                     fetch = (int)fast_read(source, src, 3);
                  }

                  last_hashed = dst - 1;
               } else {
                  if (dst > last_matchstart) {
                     while(dst <= size - 1) {
                        if (cword_val == 1L) {
                           src += 4;
                           cword_val = 2147483648L;
                        }

                        destination[dst] = source[src];
                        ++dst;
                        ++src;
                        cword_val >>>= 1;
                     }

                     return destination;
                  }

                  destination[dst] = source[src];
                  ++dst;
                  ++src;
                  cword_val >>>= 1;
                  if (level != 1) {
                     fetch = fetch >> 8 & '\uffff' | (source[src + 2] & 255) << 16 | (source[src + 3] & 255) << 24;
                  } else {
                     while(last_hashed < dst - 3) {
                        ++last_hashed;
                        matchlen = (int)fast_read(destination, last_hashed, 3);
                        hash = (matchlen >>> 12 ^ matchlen) & 4095;
                        hashtable[hash] = last_hashed;
                        hash_counter[hash] = 1;
                     }

                     fetch = fetch >> 8 & '\uffff' | (source[src + 2] & 255) << 16;
                  }
               }
            }
         }
      }
   }
}
