package com.ffcs.ebp.ebpsdk.security;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class RSAUtils {
   private static final String DEFAULT_CHARSET_NAME = "UTF-8";
   public static final String KEY_ALGORITHM = "RSA";
   public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
   private static final String PUBLIC_KEY = "RSAPublicKey";
   private static final String PRIVATE_KEY = "RSAPrivateKey";
   private static final int MAX_ENCRYPT_BLOCK = 117;
   private static final int MAX_DECRYPT_BLOCK = 128;
   private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
   private static String hexString = "0123456789ABCDEF";

   public static Map<String, Object> genKeyPair() throws Exception {
      KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
      keyPairGen.initialize(1024);
      KeyPair keyPair = keyPairGen.generateKeyPair();
      RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
      RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
      Map<String, Object> keyMap = new HashMap(2);
      keyMap.put("RSAPublicKey", publicKey);
      keyMap.put("RSAPrivateKey", privateKey);
      return keyMap;
   }

   public static Map<String, Object> setgenKeyPair(RSAPublicKey publicKey, RSAPrivateKey privateKy) throws Exception {
      Map<String, Object> keyMap = new HashMap(2);
      keyMap.put("RSAPublicKey", publicKey);
      keyMap.put("RSAPrivateKey", privateKy);
      return keyMap;
   }

   public static String sign(byte[] data, String privateKey) throws Exception {
      byte[] keyBytes = Base64.decode(privateKey);
      PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
      KeyFactory keyFactory = KeyFactory.getInstance("RSA");
      PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
      Signature signature = Signature.getInstance("MD5withRSA");
      signature.initSign(privateK);
      signature.update(data);
      return Base64.encode(signature.sign());
   }

   public static String sign(byte[] data, PrivateKey privateK) throws Exception {
      Signature signature = Signature.getInstance("MD5withRSA");
      signature.initSign(privateK);
      signature.update(data);
      return encodeHexStr(signature.sign());
   }

   public static String decode(String bytes) {
      ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length() / 2);

      for(int i = 0; i < bytes.length(); i += 2) {
         baos.write(hexString.indexOf(bytes.charAt(i)) << 4 | hexString.indexOf(bytes.charAt(i + 1)));
      }

      return new String(baos.toByteArray());
   }

   public static String encodeHexStr(byte[] data) {
      return encodeHexStr(data, HEX_CHAR);
   }

   protected static String encodeHexStr(byte[] data, char[] toDigits) {
      return new String(encodeHex(data, toDigits));
   }

   protected static char[] encodeHex(byte[] data, char[] toDigits) {
      int l = data.length;
      char[] out = new char[l << 1];
      int i = 0;

      for(int var5 = 0; i < l; ++i) {
         out[var5++] = toDigits[(240 & data[i]) >>> 4];
         out[var5++] = toDigits[15 & data[i]];
      }

      return out;
   }

   protected static int toDigit(char ch, int index) {
      int digit = Character.digit(ch, 16);
      if (digit == -1) {
         throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
      } else {
         return digit;
      }
   }

   public static byte[] decodeHex(char[] data) {
      int len = data.length;
      if ((len & 1) != 0) {
         throw new RuntimeException("Odd number of characters.");
      } else {
         byte[] out = new byte[len >> 1];
         int i = 0;

         for(int j = 0; j < len; ++i) {
            int f = toDigit(data[j], j) << 4;
            ++j;
            f |= toDigit(data[j], j);
            ++j;
            out[i] = (byte)(f & 255);
         }

         return out;
      }
   }

   public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
      byte[] keyBytes = Base64.decode(publicKey);
      X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
      KeyFactory keyFactory = KeyFactory.getInstance("RSA");
      PublicKey publicK = keyFactory.generatePublic(keySpec);
      Signature signature = Signature.getInstance("MD5withRSA");
      signature.initVerify(publicK);
      signature.update(data);
      return signature.verify(Base64.decode(sign));
   }

   public static boolean verify(byte[] data, PublicKey publicK, String sign) throws Exception {
      Signature signature = Signature.getInstance("MD5withRSA");
      signature.initVerify(publicK);
      signature.update(data);
      return signature.verify(decodeHex(sign.toCharArray()));
   }

   public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws Exception {
      byte[] keyBytes = Base64.decode(privateKey);
      PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
      KeyFactory keyFactory = KeyFactory.getInstance("RSA");
      Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);
      Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
      cipher.init(2, privateK);
      int inputLen = encryptedData.length;
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      int offSet = 0;

      for(int i = 0; inputLen - offSet > 0; offSet = i * 128) {
         byte[] cache;
         if (inputLen - offSet > 128) {
            cache = cipher.doFinal(encryptedData, offSet, 128);
         } else {
            cache = cipher.doFinal(encryptedData, offSet, inputLen - offSet);
         }

         out.write(cache, 0, cache.length);
         ++i;
      }

      byte[] decryptedData = out.toByteArray();
      out.close();
      return decryptedData;
   }

   public static byte[] decryptByPublicKey(byte[] encryptedData, String publicKey) throws Exception {
      byte[] keyBytes = Base64.decode(publicKey);
      X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
      KeyFactory keyFactory = KeyFactory.getInstance("RSA");
      Key publicK = keyFactory.generatePublic(x509KeySpec);
      Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
      cipher.init(2, publicK);
      int inputLen = encryptedData.length;
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      int offSet = 0;

      for(int i = 0; inputLen - offSet > 0; offSet = i * 128) {
         byte[] cache;
         if (inputLen - offSet > 128) {
            cache = cipher.doFinal(encryptedData, offSet, 128);
         } else {
            cache = cipher.doFinal(encryptedData, offSet, inputLen - offSet);
         }

         out.write(cache, 0, cache.length);
         ++i;
      }

      byte[] decryptedData = out.toByteArray();
      out.close();
      return decryptedData;
   }

   public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
      byte[] keyBytes = Base64.decode(publicKey);
      X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
      KeyFactory keyFactory = KeyFactory.getInstance("RSA");
      Key publicK = keyFactory.generatePublic(x509KeySpec);
      Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
      cipher.init(1, publicK);
      int inputLen = data.length;
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      int offSet = 0;

      for(int i = 0; inputLen - offSet > 0; offSet = i * 117) {
         byte[] cache;
         if (inputLen - offSet > 117) {
            cache = cipher.doFinal(data, offSet, 117);
         } else {
            cache = cipher.doFinal(data, offSet, inputLen - offSet);
         }

         out.write(cache, 0, cache.length);
         ++i;
      }

      byte[] encryptedData = out.toByteArray();
      out.close();
      return encryptedData;
   }

   public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
      byte[] keyBytes = Base64.decode(privateKey);
      PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
      KeyFactory keyFactory = KeyFactory.getInstance("RSA");
      Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);
      Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
      cipher.init(1, privateK);
      int inputLen = data.length;
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      int offSet = 0;

      for(int i = 0; inputLen - offSet > 0; offSet = i * 117) {
         byte[] cache;
         if (inputLen - offSet > 117) {
            cache = cipher.doFinal(data, offSet, 117);
         } else {
            cache = cipher.doFinal(data, offSet, inputLen - offSet);
         }

         out.write(cache, 0, cache.length);
         ++i;
      }

      byte[] encryptedData = out.toByteArray();
      out.close();
      return encryptedData;
   }

   public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
      Key key = (Key)keyMap.get("RSAPrivateKey");
      return Base64.encode(key.getEncoded());
   }

   public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
      Key key = (Key)keyMap.get("RSAPublicKey");
      return Base64.encode(key.getEncoded());
   }

   public PublicKey getPublicKey(String modulus, String publicExponent) throws Exception {
      BigInteger m = new BigInteger(modulus, 16);
      BigInteger e = new BigInteger(publicExponent, 16);
      RSAPublicKeySpec keySpec = new RSAPublicKeySpec(m, e);
      KeyFactory keyFactory = KeyFactory.getInstance("RSA");
      PublicKey publicKey = keyFactory.generatePublic(keySpec);
      return publicKey;
   }

   public PrivateKey getPrivateKey(String modulus, String privateExponent) throws Exception {
      BigInteger m = new BigInteger(modulus, 16);
      BigInteger e = new BigInteger(privateExponent, 16);
      RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(m, e);
      KeyFactory keyFactory = KeyFactory.getInstance("RSA");
      PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
      return privateKey;
   }

   public void testGenKey() throws Exception {
      Map<String, Object> keyMap = genKeyPair();
      RSAPublicKey publicKey = (RSAPublicKey)keyMap.get("RSAPublicKey");
      RSAPrivateKey prvateKey = (RSAPrivateKey)keyMap.get("RSAPrivateKey");
      String publicKeyValue = Base64.encode(publicKey.getEncoded());
      String privateKeyValue = Base64.encode(prvateKey.getEncoded());
      System.out.println("公钥=" + publicKeyValue);
      System.out.println("私钥=" + privateKeyValue);
   }

   public String testEncrypt(String cotent, String publicKey) throws Exception {
      System.out.println("要加密的数据：" + cotent);
      byte[] encode_b = cotent.getBytes();
      byte[] encode = encryptByPublicKey(encode_b, publicKey);
      String encode16 = encodeHexStr(encode);
      System.out.println("公钥加密结果：" + encode16);
      return encode16;
   }

   public String testDecrypt(String encode16, String privateKey) throws Exception {
      byte[] encode = decodeHex(encode16.toCharArray());
      byte[] decode = decryptByPrivateKey(encode, privateKey);
      System.out.println("私钥解密结果：" + new String(decode));
      return new String(decode);
   }

   public static void main(String[] args) throws Exception {
      Map map = genKeyPair();
   }

   public static String decryptByPrivateKeyStr(String encryptedDataStr, String privateKey) throws Exception {
      byte[] encryptedData = HexByteUtil.hexStr2ByteArr(encryptedDataStr);
      String str = new String(decryptByPrivateKey(encryptedData, privateKey), "UTF-8");
      return str;
   }
}
